import { _ as _sfc_main$6 } from './CardTitle-BpogD0MX.mjs';
import { cva } from 'class-variance-authority';
import { defineComponent, mergeProps, withCtx, unref, createTextVNode, toDisplayString, createVNode, renderSlot, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderSlot } from 'vue/server-renderer';
import { reactiveOmit } from '@vueuse/core';
import { Primitive } from 'reka-ui';
import { c as cn } from './utils-H80jjgLf.mjs';
import { _ as __nuxt_component_0$1 } from './nuxt-link-BN00xLu-.mjs';
import { Calendar, ArrowRight } from 'lucide-vue-next';

const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Badge",
  __ssrInlineRender: true,
  props: {
    asChild: { type: Boolean },
    as: {},
    variant: {},
    class: {}
  },
  setup(__props) {
    const props = __props;
    const delegatedProps = reactiveOmit(props, "class");
    return (_ctx, _push, _parent, _attrs) => {
      _push(ssrRenderComponent(unref(Primitive), mergeProps({
        "data-slot": "badge",
        class: unref(cn)(unref(badgeVariants)({ variant: __props.variant }), props.class)
      }, unref(delegatedProps), _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
          } else {
            return [
              renderSlot(_ctx.$slots, "default")
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ui/badge/Badge.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const badgeVariants = cva(
  "inline-flex items-center justify-center rounded-md border px-2 py-0.5 text-xs font-medium w-fit whitespace-nowrap shrink-0 [&>svg]:size-3 gap-1 [&>svg]:pointer-events-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive transition-[color,box-shadow] overflow-hidden",
  {
    variants: {
      variant: {
        default: "border-transparent bg-primary text-primary-foreground [a&]:hover:bg-primary/90",
        secondary: "border-transparent bg-secondary text-secondary-foreground [a&]:hover:bg-secondary/90",
        destructive: "border-transparent bg-destructive text-white [a&]:hover:bg-destructive/90 focus-visible:ring-destructive/20 dark:focus-visible:ring-destructive/40 dark:bg-destructive/60",
        outline: "text-foreground [a&]:hover:bg-accent [a&]:hover:text-accent-foreground"
      }
    },
    defaultVariants: {
      variant: "default"
    }
  }
);
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "item",
  __ssrInlineRender: true,
  props: {
    blog: {}
  },
  setup(__props) {
    const props = __props;
    const { title, excerpt, image, slug, publishedAt, category } = props.blog;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Card = _sfc_main$6;
      const _component_Badge = _sfc_main$1;
      const _component_NuxtLink = __nuxt_component_0$1;
      _push(ssrRenderComponent(_component_Card, mergeProps({ class: "py-0 overflow-hidden hover:shadow-strong transition-all duration-300 hover:-translate-y-2 group animate-fade-in" }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="relative overflow-hidden aspect-video"${_scopeId}><img${ssrRenderAttr("src", unref(image))}${ssrRenderAttr("alt", unref(title))} loading="lazy" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Badge, { class: "absolute top-3 left-3 bg-primary text-primary-foreground px-3 py-1 rounded-full text-sm font-medium" }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref(category)?.name)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref(category)?.name), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div><div class="pb-3 px-3"${_scopeId}><h3 class="text-xl font-semibold mb-3 line-clamp-2 group-hover:text-primary transition-colors"${_scopeId}>${ssrInterpolate(unref(title))}</h3><p class="text-muted-foreground mb-4 line-clamp-2"${_scopeId}>${ssrInterpolate(unref(excerpt))}</p><div class="flex items-center justify-between text-sm text-muted-foreground mb-4"${_scopeId}><div class="flex items-center"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(Calendar), { class: "w-4 h-4 mr-1" }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(unref(publishedAt))}</div></div>`);
            _push2(ssrRenderComponent(_component_NuxtLink, {
              to: `/blog/${unref(slug)}`,
              class: "text-primary hover:text-primary-hover inline-flex items-center font-medium group/link"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(` Read More `);
                  _push3(ssrRenderComponent(unref(ArrowRight), { class: "w-4 h-4 ml-1 group-hover/link:translate-x-1 transition-transform" }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createTextVNode(" Read More "),
                    createVNode(unref(ArrowRight), { class: "w-4 h-4 ml-1 group-hover/link:translate-x-1 transition-transform" })
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "relative overflow-hidden aspect-video" }, [
                createVNode("img", {
                  src: unref(image),
                  alt: unref(title),
                  loading: "lazy",
                  class: "w-full h-full object-cover group-hover:scale-110 transition-transform duration-500"
                }, null, 8, ["src", "alt"]),
                createVNode(_component_Badge, { class: "absolute top-3 left-3 bg-primary text-primary-foreground px-3 py-1 rounded-full text-sm font-medium" }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(category)?.name), 1)
                  ]),
                  _: 1
                })
              ]),
              createVNode("div", { class: "pb-3 px-3" }, [
                createVNode("h3", { class: "text-xl font-semibold mb-3 line-clamp-2 group-hover:text-primary transition-colors" }, toDisplayString(unref(title)), 1),
                createVNode("p", { class: "text-muted-foreground mb-4 line-clamp-2" }, toDisplayString(unref(excerpt)), 1),
                createVNode("div", { class: "flex items-center justify-between text-sm text-muted-foreground mb-4" }, [
                  createVNode("div", { class: "flex items-center" }, [
                    createVNode(unref(Calendar), { class: "w-4 h-4 mr-1" }),
                    createTextVNode(" " + toDisplayString(unref(publishedAt)), 1)
                  ])
                ]),
                createVNode(_component_NuxtLink, {
                  to: `/blog/${unref(slug)}`,
                  class: "text-primary hover:text-primary-hover inline-flex items-center font-medium group/link"
                }, {
                  default: withCtx(() => [
                    createTextVNode(" Read More "),
                    createVNode(unref(ArrowRight), { class: "w-4 h-4 ml-1 group-hover/link:translate-x-1 transition-transform" })
                  ]),
                  _: 1
                }, 8, ["to"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/blog/item.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_0 = Object.assign(_sfc_main, { __name: "BlogItem" });

export { __nuxt_component_0 as _ };
//# sourceMappingURL=item-0ploePFt.mjs.map
